<!DOCTYPE html>
<html>
<head>
    <title>Image and Video Slideshow</title>
    <style>
        body {
            margin: 0;
            padding: 0;
        }
        img, video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: fill;
        }
        .slide-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            background-color: gray;
            border-radius: 50%;
            margin: 5px;
            cursor: pointer;
        }
        .active {
            background-color: white;
        }
    </style>
</head>
<body>
    <div id="slideshow"></div>
    <div id="slide-indicators"></div>

<script>
    var slideshow = document.getElementById("slideshow");

    // Obtener los medios (imágenes y videos) del archivo PHP
    fetch('qrcode.php')
        .then(response => response.json())
        .then(data => {
            var mediaUrls = data.map(obj => obj.AdUrl);
            loadSlides(mediaUrls);
        });

    // Función para detectar si el archivo es una imagen o un video
    function getMediaType(url) {
        var extension = url.split('.').pop().toLowerCase();
        if (["jpg", "jpeg", "png", "gif"].includes(extension)) {
            return "image";
        } else if (extension === "mp4") {
            return "video";
        } else {
            return null;
        }
    }

    // Función para cargar las diapositivas con imágenes y videos
    function loadSlides(mediaUrls) {
        var i;
        for (i = 0; i < mediaUrls.length; i++) {
            var mediaType = getMediaType(mediaUrls[i]);
            var slideElement;
            if (mediaType == "image") {
                slideElement = document.createElement("img");
                // Agregar un timestamp único para evitar la caché
                slideElement.src = mediaUrls[i] + "?t=" + new Date().getTime(); // Timestamp para evitar cache
            } else if (mediaType == "video") {
                slideElement = document.createElement("video");
                slideElement.src = mediaUrls[i];
                slideElement.autoplay = true;
                slideElement.controls = false; // desactivar controles
                slideElement.muted = true; // poner video en mute para autoplay
                slideElement.loop = false; // no hacer loop del video
                slideElement.addEventListener('ended', function () {
                    setTimeout(showSlides, 0); // cambiar a la siguiente diapositiva cuando el video termine
                });
            }
            slideshow.appendChild(slideElement);
        }
        showSlides();
    }

    var slideIndex = 0;

    // Función para mostrar las diapositivas
    function showSlides() {
        var i;
        var slides = slideshow.childNodes;
        for (i = 0; i < slides.length; i++) {
            if (slides[i].tagName == "IMG" || slides[i].tagName == "VIDEO") {
                slides[i].style.display = "none";  // Esconde todas las diapositivas
            }
        }
        slideIndex++;
        if (slideIndex > slides.length) {
            slideIndex = 1;  // Reinicia al primer slide si llegamos al final
        }
        if (slides[slideIndex - 1].tagName == "IMG") {
            slides[slideIndex - 1].style.display = "block";
            setTimeout(showSlides, 4000); // Cambiar diapositiva cada 4 segundos para imágenes
        } else if (slides[slideIndex - 1].tagName == "VIDEO") {
            slides[slideIndex - 1].style.display = "block";
            slides[slideIndex - 1].play();  // Reproduce el video
        }
    }
</script>

</body>
</html>
