<?php
include './includes/header.php';

// Leer el archivo JSON
$jsonData = file_get_contents('img/api.json');
$jsonArray = json_decode($jsonData, true);

// Extraer las URLs y títulos de las imágenes
$imageUrls = [];
$imageTitles = [];
for ($i = 1; $i <= 10; $i++) {
    $imageUrls[] = $jsonArray['data'][0]["url" . $i]; // Obtener las URLs url1 hasta url10
    $imageTitles[] = $jsonArray['data'][0]["title" . $i]; // Obtener los títulos title1 hasta title10
}

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => 1]);
    echo "<script>alert('Sucesso!');window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

// Función para actualizar el JSON con la nueva imagen
function updateJson($imageIndex, $imagePath) {
    $jsonData = file_get_contents('img/api.json');
    $jsonArray = json_decode($jsonData, true);

    // Obtener el dominio y la ruta base
    $domain = "https://" . $_SERVER['HTTP_HOST'];
    $basePath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');

    // Construir la URL completa
    $fullUrl = $domain . $basePath . $imagePath;

    // Actualizar el JSON
    $jsonArray['data'][0]["url" . $imageIndex] = $fullUrl;

    // Guardar el JSON actualizado
    file_put_contents('img/api.json', json_encode($jsonArray, JSON_PRETTY_PRINT));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $imageIndex = $_POST['image_index'];
    $uploadedFile = $_FILES['image'];

    // Verificar si el archivo se subió correctamente
    if ($uploadedFile['error'] !== UPLOAD_ERR_OK) {
        echo "<script>alert('Error al subir el archivo.');</script>";
        exit;
    }

    // Ruta relativa a la carpeta img (desde la ubicación del script)
    $relativeImgPath = dirname($_SERVER['SCRIPT_NAME']) . '/img/';
    $uploadDir = $_SERVER['DOCUMENT_ROOT'] . $relativeImgPath;

    // Verificar que la carpeta img existe
    if (!is_dir($uploadDir)) {
        echo "<script>alert('La carpeta img no existe.');</script>";
        exit;
    }

    // Verificar que el archivo es una imagen PNG válida
    $allowedTypes = ['image/png'];
    $fileType = mime_content_type($uploadedFile['tmp_name']);
    if (!in_array($fileType, $allowedTypes)) {
        echo "<script>alert('Solo se permiten archivos PNG.');</script>";
        exit;
    }

    // Ruta relativa para guardar en el JSON
    $filePath = '/img/' . basename($uploadedFile['name']);

    // Ruta absoluta para mover el archivo
    $fullPath = $uploadDir . basename($uploadedFile['name']);

    // Mover el archivo subido a la carpeta img
    if (move_uploaded_file($uploadedFile['tmp_name'], $fullPath)) {
        // Actualizar el JSON con la nueva URL de la imagen
        updateJson($imageIndex, $filePath);
        echo "<script>alert('Imagen actualizada con éxito!');window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
    } else {
        echo "<script>alert('Error al subir la imagen.');</script>";
    }
}
?>

<style>
    .image-container {
        background-color: #003366; /* Azul escuro */
        padding: 10px;
        border-radius: 5px;
        text-align: center;
    }

    .image-container img {
        width: 30px;  /* Largura de 30px */
        height: 30px; /* Altura de 30px */
        object-fit: cover; /* Garantir que a imagem mantenha o aspecto mesmo com o corte */
    }

    .image-title {
        text-align: center;
        font-size: 18px;
        margin-bottom: 10px;
        color: #ffffff; /* Color del texto */
        font-weight: bold;
    }
</style>

<!-- Exibir as imagens -->
<div class="mt-4">
    <h5>Cambiar iconos de la Aplicación:</h5>
    <div class="row">
        <?php foreach ($imageUrls as $index => $imageUrl): ?>
            <div class="col-md-4 mb-3">
                <!-- Título de la imagen -->
                <div class="image-title">
                    <strong><?php echo htmlspecialchars($imageTitles[$index]); ?></strong>
                </div>

                <!-- Exibe a imagem em cima do botão dentro de um fundo azul escuro -->
                <div class="image-container">
                    <?php if (!empty($imageUrl)): ?>
                        <img src="<?php echo htmlspecialchars($imageUrl); ?>" alt="Imagem <?php echo $index + 1; ?>" class="img-fluid mb-2" />
                    <?php else: ?>
                        <p>No hay imagen</p>
                    <?php endif; ?>
                </div>

                <!-- Formulário para alterar la imagen -->
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="image_index" value="<?php echo $index + 1; ?>">
                    <!-- Campo de upload da imagem -->
                    <input type="file" name="image" accept="image/png" class="form-control-file">
                    <button type="submit" class="btn btn-sm btn-warning mt-2 w-100">Cambiar Icono</button>
                </form>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?php include './includes/footer.php'; ?>