<?php
// Caminho para o arquivo splashscreen.txt que contém a URL do vídeo
$url = trim(file_get_contents("./splashscreen/splashscreen.txt"));
$url = str_replace(" ", "%20", $url);

// Verifica se o método GET 'info' foi passado com o valor 'head'
if (isset($_GET['info']) && $_GET['info'] === 'head') {
    // Inicializa o cURL
    $ch = curl_init();

    // Configurações do cURL para obter apenas os cabeçalhos
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true); // Incluir os cabeçalhos na resposta
    curl_setopt($ch, CURLOPT_NOBODY, false); // Não baixar o corpo do conteúdo

    // Executa a requisição
    $response = curl_exec($ch);

    // Verifica se houve erro no cURL
    if (curl_errno($ch)) {
        header("Content-Type: text/plain");
        echo 'Erro: ' . curl_error($ch);
        curl_close($ch);
        exit;
    }

    // Obtém o tamanho do vídeo a partir do cabeçalho Content-Length
    $contentLength = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);

    // Verifica se o tamanho foi obtido
    if ($contentLength != -1) {
        // Retorna o tamanho do vídeo
        header("Content-Type: text/plain");
        echo $contentLength;
    } else {
        echo "Não foi possível determinar o tamanho do vídeo.";
    }

    // Fecha a sessão do cURL
    curl_close($ch);
} else {
    // Inicializa o cURL para obter o conteúdo do vídeo
    $ch = curl_init();

    // Configurações do cURL
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    // Obtém o conteúdo do vídeo
    $videoContent = curl_exec($ch);

    // Verifica se houve erro no cURL
    if (curl_errno($ch)) {
        header("Content-Type: text/plain");
        echo 'Erro: ' . curl_error($ch);
        curl_close($ch);
        exit;
    }

    // Obtém informações sobre o tipo MIME usando fileinfo
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $tempFile = tempnam(sys_get_temp_dir(), 'video_');
    file_put_contents($tempFile, $videoContent);
    $mimeType = finfo_file($finfo, $tempFile);
    finfo_close($finfo);
    unlink($tempFile);

    // Define o Content-Type na resposta HTTP
    header("Content-Type: $mimeType");

    // Exibe o conteúdo do vídeo
    echo $videoContent;

    // Fecha a sessão do cURL
    curl_close($ch);
}
?>
