<?php
// Caminho do arquivo de log dentro da pasta 'api'
$logFilePath = __DIR__ . '/api/connection_log.json';

// Ler os registros do log
$logData = json_decode(file_get_contents($logFilePath), true);

// Verificar se houve erro ao decodificar o JSON
if ($logData === null) {
    die("Erro ao ler o arquivo JSON: " . json_last_error_msg());
}

// Garantir que $logData seja um array válido
if (!is_array($logData)) {
    $logData = [];
}

// Mostrar apenas os últimos 50 registros
$logData = array_slice($logData, -50);

// Filtrar registros para mostrar apenas a última entrada de cada MAC
$uniqueMacs = [];

foreach ($logData as $entry) {
    $mac = $entry['mac_address'] ?? null;
    $date = $entry['date'] ?? null;

    // Verificar se o MAC já existe na lista e se a data é mais recente
    if ($mac && $date) {
        if (!isset($uniqueMacs[$mac]) || strtotime($date) > strtotime($uniqueMacs[$mac]['date'])) {
            $uniqueMacs[$mac] = $entry;
        }
    }
}

// Reindexar o array com as entradas únicas
$logData = array_values($uniqueMacs);

// Verificar se existe a requisição para excluir registros
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    $deleteIds = $_POST['delete']; // IDs dos logs selecionados para exclusão
    // Filtrar os registros para excluir os selecionados
    $logData = array_filter($logData, function ($entry) use ($deleteIds) {
        return !in_array($entry['mac_address'], $deleteIds);
    });
    
    // Reindexar o array após a remoção
    $logData = array_values($logData);

    // Atualizar o arquivo JSON
    file_put_contents($logFilePath, json_encode($logData, JSON_PRETTY_PRINT));

    // Atualizar a página após a exclusão
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Incluir o cabeçalho da página
include "includes/header.php";
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monitor de Estado</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            color: #333;
        }

        h1 {
            text-align: center;
            margin-top: 20px;
            color: white;
            background-color: #333;
            padding: 10px;
            border-radius: 8px;
        }

        table {
            width: 80%;
            margin: 30px auto;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
        }

        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #333;
            color: white;
        }

        td {
            background-color: #fff;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        .no-data {
            text-align: center;
            font-style: italic;
            color: #888;
        }

        i {
            margin-right: 8px;
            color: #555;
        }

        .actions {
            text-align: center;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <h1>Monitor de Estado</h1>

    <!-- Formulário para exclusão de registros -->
    <form method="POST" action="">
        <div class="actions">
            <button type="submit" name="deleteAll" class="delete-all" onclick="return confirm('¿Estás seguro de que quieres eliminar todos los registros seleccionados?')">Eliminar Seleccionados</button>
        </div>

        <table>
            <thead>
                <tr>
                    <th><input type="checkbox" id="select-all"> <i class="fas fa-key"></i> Código de Acceso</th>
                    <th><i class="fas fa-clock"></i> Último Visto Online</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($logData)): ?>
                    <?php foreach ($logData as $entry): ?>
                        <tr>
                            <td>
                                <input type="checkbox" name="delete[]" value="<?= htmlspecialchars($entry['mac_address']) ?>">
                                <i class="fas fa-key"></i> <?= htmlspecialchars($entry['mac_address'] ?? 'N/A') ?>
                            </td>
                            <td><i class="fas fa-clock"></i> <?= htmlspecialchars($entry['date'] ?? 'N/A') ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="2" class="no-data">No se encontraron registros de conexión.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </form>

    <script>
        // Seleção e deseleção de todos os checkboxes
        document.getElementById('select-all').addEventListener('change', function() {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = this.checked;
            });
        });
    </script>

</body>
</html>

<?php
// Incluir o rodapé da página
include "includes/footer.php";
?>
