<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Painel IBO">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
</head>
<body>
<style>
body{
  background-color: #181828;
  background-image: url("./img/binding_dark.webp");
  color: #fff;
}

#particles-js{
  background-size: cover;
  background-position: 50% 50%;
  background-repeat: no-repeat;
  background: #8000FF;
  display: flex;
  justify-content: center;
  align-items: center;
}

.particles-js-canvas-el{
  position: fixed;
}

#pageMessages {
  left: 50%;
  transform: translateX(-50%);
  position: fixed; 
  text-align: center;
  top: 5px;
  width: 60%;
  z-index: 9999; 
  border-radius: 0px;
}

.alert {
  position: relative;
}

.alert .close {
  position: absolute;
  top: 5px;
  right: 5px;
  font-size: 1em;
}

.alert .fa {
  margin-right: .3em;
}
</style>
<div id="js-particles"></div>

<div class="d-flex" id="wrapper">
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">IBO 3.9 (5 Themes) </div>
        <span>
            <a class="list-group-item" href="https://ibomods.com/" target="_blank">&nbsp;&nbsp;&nbsp;&nbsp;&#169; <?=date("Y")?> IBO MODS </a>
        </span>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fa fa-cogs"></i>&nbsp;&nbsp;DNS Servers
            </a>
            <a class="list-group-item list-group-item-action" href="playlists.php">
                <i class="fa fa-user"></i>&nbsp;&nbsp;Active Users
            </a>
            <a class="list-group-item list-group-item-action" href="themes.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Themes
            </a>
            <a class="list-group-item list-group-item-action" href="ads.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Banners
            </a>
            <a class="list-group-item list-group-item-action" href="mRTXAdsSetting.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Autoads / Manual
            </a>
            <a class="list-group-item list-group-item-action" href="logo.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Logo
            </a>
            <a class="list-group-item list-group-item-action" href="bg.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;Background
            </a>
            <a class="list-group-item list-group-item-action" href="qrcode.php">
                <i class="fa fa-image"></i>&nbsp;&nbsp;QR Code
            </a>

            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fa fa-user"></i>&nbsp;&nbsp;Admin
            </a>
            <!-- Novo Botão Mensagem -->
            <a class="list-group-item list-group-item-action" href="./edit_texto.php">
                <i class="fa fa-envelope"></i>&nbsp;&nbsp;Dashboard message
            </a>
            <a class="list-group-item list-group-item-action" target="_blank" href="texto.php">
                <i class="fa fa-envelope"></i>&nbsp;&nbsp;Popup message
            </a>
        </div>
    </div>
    <!-- /#sidebar-wrapper -->

    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <button class="btn btn-primary" id="menu-toggle">
                <img src="img/logo.png" width="25" height="25" class="d-flex justify-content-center text-align centre" alt="">
            </button>
            &nbsp;&nbsp;
            <div class="center" id="pageMessages"></div>
            <a href="logout.php" class="btn btn-danger ml-auto mr-1">Logout</a>
        </nav>
        <div class="container-fluid"><br>