<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Texto para Imagem</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f3e0ac;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            padding: 10px; /* Adicionado para permitir algum espaço em telas menores */
        }
        .form-container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            text-align: center; /* Centraliza o conteúdo dentro da caixa */
        }
        .logo-container {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        .logo-container img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
        }
        .form-container h2 {
            margin-top: 0;
            font-size: 24px;
        }
        .form-container label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: red; /* Adicionado para deixar o texto vermelho */
        }
        .form-container input[type="text"],
        .form-container textarea {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box; /* Adicionado para garantir que a largura inclua padding e borda */
        }
        .form-container textarea {
            resize: vertical; /* Permite redimensionar verticalmente */
            min-height: 150px; /* Aumenta a altura mínima da caixa de texto */
        }
        .form-container input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #007BFF;
            border: none;
            border-radius: 5px;
            color: #fff;
            font-size: 16px;
            cursor: pointer;
        }
        .form-container input[type="submit"]:hover {
            background-color: #0056b3;
        }
        /* Novo estilo para o aviso de limite de caracteres */
        #char-limit-warning {
            font-size: 14px;
            color: red;
            margin-top: -5px; /* Ajuste de margem para alinhar com a caixa de texto */
        }
    </style>
</head>
<body>
    <div class="form-container">
        <div class="logo-container">
            <img src="img/logo.png" alt="Logo">
        </div>
        <h2>Crear un mensaje de Bienvenida!</h2>
        <!-- Adicionado um parágrafo para exibir o aviso sobre o limite de caracteres -->
        <p id="char-limit-warning"></p>
        <form id="messageForm">
            <label for="text" style="color: red;">Obs: Máx 71 caracteres:</label>
            <textarea id="text" name="text" rows="4" required maxlength="71"></textarea>
            <input type="submit" value="Crear mensaje">
        </form>
    </div>

    <!-- Script modificado para exibir o alerta de sucesso e evitar redirecionamento -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var textArea = document.getElementById('text');
            var charLimitWarning = document.getElementById('char-limit-warning');
            var form = document.getElementById('messageForm');

            textArea.addEventListener('input', function () {
                var charCount = textArea.value.length;
                if (charCount > 71) {
                    charLimitWarning.textContent = 'Limite de caracteres excedido!';
                } else {
                    charLimitWarning.textContent = '';
                }
            });

            // Intercepta o envio do formulário
            form.addEventListener('submit', function(event) {
                event.preventDefault(); // Impede o comportamento padrão de envio do formulário

                // Simulação do envio via AJAX (exemplo básico, pode ser ajustado)
                var formData = new FormData(form);

                fetch('generate_image.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (response.ok) {
                        alert('Imagem salva com sucesso!');
                        form.reset(); // Limpa o formulário
                    } else {
                        alert('Erro ao salvar a imagem!');
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao enviar a mensagem.');
                });
            });
        });
    </script>
</body>
</html>
