<?php
include "includes/header.php";
?>
<style>
  /* Ajustes de layout para telas menores */
  .container-fluid {
    margin-top: 20px; /* Garantir espaçamento do topo */
  }

  .custom-button {
    padding: 10px 20px;
    font-size: 16px; /* Aumentar o tamanho da fonte */
  }

  #url-form {
    display: none;
  }

  .custom-input {
    color: blue;
  }

  .preview-image {
    max-width: 100%;
    height: auto;
  }

  /* Estilos responsivos */
  @media (max-width: 768px) {
    .container-fluid {
      padding-left: 10px;
      padding-right: 10px;
    }

    .card-body {
      padding: 15px;
    }

    .card-header h6 {
      font-size: 1rem; /* Reduzir tamanho do texto no cabeçalho */
    }

    h1.h3 {
      font-size: 1.5rem; /* Reduzir tamanho do título */
    }

    .custom-button {
      width: 100%; /* Tornar os botões mais largos nas telas pequenas */
      margin-bottom: 10px;
    }

    #upload-form,
    #url-form {
      width: 100%;
    }

    input[type="file"] {
      padding: 10px;
    }
  }

  /* Estilo para imagens no mobile */
  .preview-image {
    max-width: 100%;
    height: auto;
  }
</style>

<div class="container-fluid">
    <!-- Cabeçalho da Página -->
    <h1 class="h3 mb-1 text-gray-800">Fundo da Imagem</h1>
    <!-- Códigos Personalizados -->
    <div class="card border-left-primary shadow h-100 card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-cogs"></i> Escolher</h6>
        </div>
        <div class="card-body">
            <?php
                $jsonFilex = './a/rtx/image_filenames.json';
        
                // Ler o conteúdo do arquivo JSON
                $jsonDatax = file_get_contents($jsonFilex);
                
                // Decodificar os dados do JSON
                $imageDatax = json_decode($jsonDatax, true);
                
                // Extrair o nome do arquivo
                $filenamex = $imageDatax[0]['ImageName'];
                $uploadmethord = $imageDatax[0]['Upload_type'];
                
                if ($uploadmethord == "by_file") {
                    $string = $filenamex;
                    $firstLetterRemoved = substr($string, 1);
                    $imageFilex = "$firstLetterRemoved";
                    $methord = "   Método de Upload";
                } elseif ($uploadmethord == "by_url") {
                    $imageFilex = "$filenamex";
                    $methord = "   Método de URL";
                } else {
                    $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
                    $methord = "";
                }
                
                echo '<h3>Atualmente em uso:' . $methord . '</h3>';
                echo '<input type="radio" name="upload-type" id="upload-radio" checked> Definir Fundo Usando Arquivo &nbsp;&nbsp;';
                echo '<input type="radio" name="upload-type" id="url-radio"> Definir Fundo Usando URL';
                echo '<br>';
                echo '<img class="preview-image" src="' . $imageFilex . '" alt="Imagem Enviada">';
                echo '<br><br>';
                
                if (isset($_POST['upload'])) {
                    // Processar o arquivo enviado
                    $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
                    $folderPath = './rtx/Img/';
                    
                    $files = scandir($folderPath);
                    
                    foreach ($files as $file) {
                        if ($file !== '.' && $file !== '..') {
                            $filePath = $folderPath . $file;
                    
                            // Verificar se o arquivo está selecionado
                            if (in_array($file, $selectedFiles)) {
                                // O arquivo está selecionado, não faz nada
                            } else {
                                // Deletar o arquivo
                                unlink($filePath);
                            }
                        }
                    }
                    
                    if (isset($_FILES['image'])) {
                        $file = $_FILES['image'];
                        $fileType = $file['type'];
                        $fileTemp = $file['tmp_name'];
                    
                        // Validar o tipo de arquivo
                        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
                        if (in_array($fileType, $allowedTypes)) {
                            // Definir o caminho para armazenar a imagem enviada
                            $uploadPath = './rtx/Img/';
                            $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                            $destination = $uploadPath . $fileName;
                    
                            // Mover o arquivo enviado para o destino
                            if (move_uploaded_file($fileTemp, $destination)) {
                                echo "<script>window.location.href='mRTXBGImage.php';</script>";
                                 
                                $jsonFilePath = './a/rtx/image_filenames.json';
                                $jsonData = json_encode([["ImageName" => "../rtx/Img/" . $fileName, 'Upload_type' => 'by_file']]);
                                file_put_contents($jsonFilePath, $jsonData);
                            } else {
                                echo 'Falha ao mover o arquivo enviado.';
                            }
                        } else {
                            echo 'Tipo de arquivo inválido. Apenas imagens JPEG, PNG e GIF são permitidas.';
                        }
                    }
                }
                // Processamento da Imagem via URL
                if (isset($_POST['url-submit'])) {
                    $imageUrl = $_POST['image-url'];
                
                    // Validar a URL
                    if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                        $jsonFilePath = './a/rtx/image_filenames.json';
                
                        // Preparar os dados a serem adicionados ao arquivo JSON
                        $newImageData = [
                            'ImageName' => $imageUrl,
                            'Upload_type' => 'by_url'
                        ];
                
                        // Ler os dados existentes no JSON
                        $jsonData = file_get_contents($jsonFilePath);
                
                        // Decodificar os dados do JSON
                        $imageData = json_decode($jsonData, true);
                
                        // Adicionar os novos dados da imagem ao array existente
                        $imageData[0] = $newImageData;
                
                        // Codificar os dados atualizados como JSON
                        $jsonData = json_encode($imageData);
                
                        // Salvar os dados atualizados no arquivo
                        if (file_put_contents($jsonFilePath, $jsonData)) {
                            echo "<script>window.location.href='mRTXBGImage.php';</script>";
                        } else {
                            echo 'Falha ao salvar os dados da imagem no arquivo JSON.';
                        }
                    } else {
                        echo 'URL inválida.';
                    }
                }
            ?>

            <form method="post" enctype="multipart/form-data" id="upload-form">
                <label for="image">Selecione uma Imagem para enviar:</label>
                <input class="custom-button" type="file" name="image" id="image" accept="image/jpeg, image/png, image/gif">
                <button class="custom-button btn btn-success btn-icon-split" type="submit" name="upload">Enviar</button>
            </form>
            
            <form method="post" id="url-form">
                <label for="image-url">Selecione uma URL de Imagem:</label>
                <input class="custom-button" type="text" name="image-url" id="image-url" placeholder="https://example.com/image.jpg">
                <button class="custom-button btn btn-success btn-icon-split" type="submit" name="url-submit">Enviar URL</button>
            </form>

            <script>
                const uploadRadio = document.getElementById('upload-radio');
                const urlRadio = document.getElementById('url-radio');
                const uploadForm = document.getElementById('upload-form');
                const urlForm = document.getElementById('url-form');
        
                uploadRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'block';
                    urlForm.style.display = 'none';
                });
        
                urlRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'none';
                    urlForm.style.display = 'block';
                });
            </script>
        </div>
    </div>
</div>

<?php
include "includes/footer.php";
?>
</body>
</html>
