<?php
include('includes/header.php');

// Função para obter a última opção salva
function obterUltimaOpcao()
{
    $arquivo = "./api/ultima_opcao1.txt";
    if (file_exists($arquivo)) {
        return file_get_contents($arquivo);
    } else {
        return "";
    }
}

// Função para obter o rótulo da opção selecionada
function obterRotuloOpcao($opcao)
{
    switch ($opcao) {
        case 'siteesportes.php':
            return 'Pagina.';
        case 'menadss.php':
            return 'Manual.';
    }
}

// Função para obter o link da imagem para cada opção
function obterLinkImagem($opcao)
{
    switch ($opcao) {
        case 'menadss.php':
            return 'midiavs/09.png';
        case 'paginaesportes.php': // Corrigido para coincidir com o valor no formulário
            return 'midiavs/10.png';
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $opcao_selecionada = $_POST["opcoes"];
    file_put_contents("./api/opcao12.txt", $opcao_selecionada);
    file_put_contents("./api/ultima_opcao12.txt", $opcao_selecionada);

    if ($opcao_selecionada === 'note.php') {
        echo '<meta http-equiv="refresh" content="0; URL=mRTXinAppText.php">';
        exit;
    } elseif ($opcao_selecionada === 'paginaesportes.php') {
        echo '<meta http-equiv="refresh" content="0; URL=siteesportes.php">';
        exit;
    } elseif ($opcao_selecionada === 'menads.php') {
        echo '<meta http-equiv="refresh" content="0; URL=fundoo.php">';
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Opções de Banner</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
  <style>
    body {
      font-family: 'Arial', sans-serif;
      font-size: 13px;
      color: #333;
      background-color: #f5f5f5;
    }

    .card {
      border: none;
      border-radius: 10px;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .card-header {
      background-color: #007bff;
      color: #fff;
      border-radius: 10px 10px 0 0;
      text-align: center;
    }

    .opcao-container {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      justify-content: center;
    }

    .opcao-item {
      flex: 1 1 calc(100% - 40px); /* Responsivo: ocupa 100% menos margens em telas pequenas */
      max-width: 300px; /* Máximo tamanho para opções em telas grandes */
      padding: 15px;
      border: 1px solid #ddd;
      border-radius: 8px;
      text-align: center;
      cursor: pointer;
      transition: background-color 0.2s ease;
    }

    @media (min-width: 768px) {
      .opcao-item {
        flex: 1 1 calc(50% - 40px); /* Em tablets, ocupa 50% da largura */
      }
    }

    @media (min-width: 992px) {
      .opcao-item {
        flex: 1 1 calc(33.33% - 40px); /* Em desktops, ocupa 1/3 da largura */
      }
    }

    .opcao-item:hover {
      background-color: #f0f0f0;
    }

    .opcao-item img {
      max-width: 100%; /* Imagens responsivas */
      height: auto;
      border-radius: 5px;
      margin-top: 10px;
    }

    .btn-primary {
      background-color: #007bff;
      border-color: #007bff;
      color: #fff;
    }

    .btn-primary:hover {
      background-color: #0056b3;
      border-color: #0056b3;
    }

    .opcao-selecionada {
      font-weight: bold;
      margin-top: 10px;
      text-align: center;
    }
  </style>
</head>

<body>
  <div class="container mt-5">
    <div class="row justify-content-center">
      <div class="col-md-8">
        <div class="card">
          <div class="card-header">
            <h2 class="mb-0">Tipo de Anúncio de Jogos</h2>
          </div>
          <div class="card-body">
            <form method="POST" action="" enctype="multipart/form-data">
              <div class="opcao-container">
                <?php
                $opcoes = [
                  'menadss.php' => 'Manual.',
                  'paginaesportes.php' => 'Página web.'
                ];
                foreach ($opcoes as $valor => $rotulo) :
                ?>
                  <div class="opcao-item">
                    <div class="form-check">
                      <input class="form-check-input" type="radio" name="opcoes" id="<?php echo $valor; ?>" value="<?php echo $valor; ?>" <?php if (obterUltimaOpcao() === $valor) echo 'checked'; ?>>
                      <label class="form-check-label radio-label" for="<?php echo $valor; ?>">
                        <?php echo $rotulo; ?>
                      </label>
                      <br>
                      <?php $link_imagem = obterLinkImagem($valor); ?>
                      <img src="<?php echo $link_imagem; ?>" alt="Imagem de exemplo">
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
              <button type="submit" name="submit" class="btn btn-primary btn-block mt-3">Salvar</button>
              <?php $ultima_opcao = obterUltimaOpcao(); ?>
              <?php if (!empty($ultima_opcao)) : ?>
                <p class="opcao-selecionada">Última opção selecionada: <?php echo obterRotuloOpcao($ultima_opcao); ?></p>
              <?php endif; ?>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include('includes/footer.php'); ?>
</body>

</html>
