<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lançamentos da Semana</title>
    <style>
        body {
            margin: 0;
            overflow: hidden;
        }
        #slider-container {
            width: 100vw;
            height: 100vh;
            display: flex;
            overflow: hidden;
        }
        #slider {
            display: flex;
            transition: opacity 0.0s ease-in-out
        }
        .movie {
            position: relative;
            width: 100vw;
            height: 100vh;
            background-size: cover;
            background-position: center;
            color: #fff;
            display: flex;
            align-items: flex-end;
        }
.overlay {
    width: 600px;
    background: linear-gradient(to left, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0.9));
    padding: 10px;
    box-sizing: border-box;
    text-align: justify;
    position: absolute;
    bottom: 50px; /* Ajuste a posição vertical conforme desejado */
    right: 50px;
    
    display: flex;
    gap: 10px;
    border-top-left-radius: 10px;
    border-bottom-left-radius: 10px;
}

        .overlay-text {
            flex: 1;
        }
        .overlay h2 {
            font-size: 1.2em;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .overlay p {
            font-size: 0.9em;
            margin-bottom: 10px;
            max-height: 150px;
            overflow: hidden;
        }
        .cover {
            width: 112px;
            height: 196px;
            background-size: cover;
            background-position: center;
        }
    </style>
</head>
<body>
    <div id="slider-container">
        <div id="slider"></div>
    </div>

    <script>
        const apiKey = '042ca3561d20c34adcc98489df9cc4b2';
        const language = 'pt-BR';

        async function fetchLatestMovies() {
            const response = await fetch(`https://api.themoviedb.org/3/movie/now_playing?api_key=${apiKey}&language=${language}`);
            const data = await response.json();
            return data.results;
        }

        async function populateSlider() {
            const movies = await fetchLatestMovies();
            const slider = document.getElementById('slider');

            movies.slice(0, 7).forEach((movie) => {
                const movieElement = document.createElement('div');
                movieElement.classList.add('movie');
                movieElement.style.backgroundImage = `url(https://image.tmdb.org/t/p/original${movie.backdrop_path})`;

                const overlay = document.createElement('div');
                overlay.classList.add('overlay');

                const overlayText = document.createElement('div');
                overlayText.classList.add('overlay-text');

                const title = document.createElement('h2');
                const releaseYear = movie.release_date ? ` (${movie.release_date.split('-')[0]})` : '';
                title.textContent = `${movie.title}${releaseYear}`;

                const overview = document.createElement('p');
                overview.textContent = movie.overview;

                const cover = document.createElement('div');
                cover.classList.add('cover');
                cover.style.backgroundImage = `url(https://image.tmdb.org/t/p/original${movie.poster_path})`;

                overlayText.appendChild(title);
                overlayText.appendChild(overview);
                overlay.appendChild(overlayText);
                overlay.appendChild(cover);

                movieElement.appendChild(overlay);
                slider.appendChild(movieElement);
            });

            animateSlider();
        }

        function animateSlider() {
            const slider = document.getElementById('slider');
            const mediaWidth = document.querySelector('.movie').offsetWidth;
            let counter = 0;

            setInterval(() => {
                counter = (counter + 1) % 7;
                slider.style.transform = `translateX(${-counter * mediaWidth}px)`;
            }, 15000);
        }

        window.onload = populateSlider;
    </script>
</body>
</html>
