<?php
session_start();
$id = $_SESSION['id'];
$db = new SQLite3("./api/db/studiolivecode_clientes.db");

// Se a solicitação for um POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se o parâmetro 'delete' foi enviado
    if (isset($_POST['delete'])) {
        $itemToDelete = $_POST['delete'];

        // Evite injeção SQL usando declarações preparadas
        $stmt = $db->prepare("DELETE FROM ibo WHERE id = :id");
        $stmt->bindValue(':id', $itemToDelete, SQLITE3_INTEGER);
        
        // Execute a exclusão
        if ($stmt->execute()) {
            // A exclusão foi bem-sucedida
            echo json_encode(array('status' => 'success'));
        } else {
            // A exclusão falhou
            echo json_encode(array('status' => 'error'));
        }
        
        exit;
    }
}

include './includes/header.php';

// Conexão com o banco de dados
$db1 = new SQLite3("./api/db/studiolivecode_users.db");

// Consulta para obter informações de admin e nível do usuário
$query = $db1->prepare("SELECT admin, nivel FROM users WHERE id = :id");
$query->bindValue(':id', $id, SQLITE3_INTEGER);
$userData = $query->execute()->fetchArray(SQLITE3_ASSOC);

?>

<div class="card radius-10">
    <div class="card-header border-bottom-0 bg-transparent">
        <div class="d-flex align-items-center">
            <div>
                <h5 class="font-weight-bold mb-0">Usuários ChatBot</h5>
            </div>
            <!-- <div class="ms-auto">
                <a href="./users_create.php">
                    <button type="button" class="btn btn-primary mr-2 radius-10">Adicionar Usuário</button>
                </a>
            </div> -->
        </div>
    </div>
    <div class="card-body">
        <!-- Título da Página -->
       
<?php if ($userData['admin'] == 1 || $userData['nivel'] == 2): ?>
<div class="col-12">
    <center>
        <button type="submit" id="delete-selected" name="delete-selected" class="btn btn-danger mr-2"><i class='bx bx-check mr-1'></i>Excluir Selecionados</button>
    </center>
<script>
$(document).ready(function() {
    $('#select-all').click(function() {
        $('input[name="selected_items[]"]').prop('checked', this.checked);
    });

    $(document).on("click", ".delete-item", function() {
        var itemId = $(this).data("id");

        if (confirm("Tem certeza de que deseja excluir este item?")) {
            $.post("users.php", { delete: itemId }, function(data) {
                if (data.status === 'success') {
                    // Exclusão bem-sucedida
                    window.location.href = "users.php?r=excluido";
                } else {
                    // Falha na exclusão
                    alert("Falha na exclusão do item com ID " + itemId);
                }
            }, 'json');
        }
    });

    $(document).on("click", "#delete-selected", function() {
        var selectedItems = [];

        $.each($("input[name='selected_items[]']:checked"), function(){
            selectedItems.push($(this).val());
        });

        if (selectedItems.length > 0) {
            if (confirm("Tem certeza de que deseja excluir os itens selecionados?")) {
                // Crie uma variável para rastrear o número de exclusões bem-sucedidas
                var successfulDeletes = 0;

                $.each(selectedItems, function(index, value) {
                    $.post("users.php", { delete: value }, function(data) {
                        if (data.status === 'success') {
                            successfulDeletes++;
                        }
                        
                        if (successfulDeletes === selectedItems.length) {
                            window.location.href = "users.php?r=all_excluido";
                        }
                    }, 'json');
                });
            }
        } else {
            alert("Selecione pelo menos um item para excluir.");
        }
    });
});
</script>

</div>
<br>
<?php endif; ?>

<div class="input-group ">
    <button onclick="searchTable()" class="btn btn-primary mr-2"><i class='bx bx-search mr-1'></i>Buscar</button>
    <input class="form-control" type="text" id="searchInput" placeholder="Buscar por Chave do Dispositivo" />
</div>
<br>
<div class="table-responsive" id="tableContainer" style="display: none;">
    <table id="myTable" class="table mb-0 align-middle">
        <thead>
            <tr>
                <th style="display: none;">id</th>
                <th><input type="checkbox" id="select-all"></th>
                <th>MAC do Dispositivo</th>
                <th>Chave do Dispositivo</th>
                <th>Dns</th>
                <th>Título</th>
                <th>Vencimento</th>
                <th>Editar</th>
                <th>Deletar</th>
            </tr>
        </thead>
        <tbody id="tableBody">
            <!-- Os dados serão carregados aqui via AJAX -->
        </tbody>
    </table>
</div>
</div>
</div>

<script>
function searchTable() {
    var input = document.getElementById("searchInput").value;
    var tableContainer = document.getElementById("tableContainer");
    var tableBody = document.getElementById("tableBody");
    tableBody.innerHTML = "";

    $.ajax({
        url: "buscar_aplicativos.php",
        method: "POST",
        data: { key: input },
        dataType: "json",
        success: function(data) {
            if (data.length > 0) {
                tableContainer.style.display = "block";
                data.forEach(function(item) {
                    var row = `<tr>
                        <td style="display: none;">${item.id}</td>
                        <td><input type="checkbox" name="selected_items[]" value="${item.id}"></td>
                        <td>${item.mac_address}</td>
                        <td>${item.key}</td>
                        <td>${item.dns}</td>
                        <td>${item.title}</td>
                        <td>${item.expire_date}</td>
                        <td><div class="d-flex order-actions"><a href="./users_update.php?update=${item.id}" class="text-light bg-primary border-0"><i class='bx bxs-edit'></i></a></div></td>
                        <td><div class="d-flex order-actions"><a href="javascript:void(0);" class="text-light bg-danger border-0 delete-item" data-id="${item.id}"><i class="bx bxs-trash"></i></a></div></td>
                    </tr>`;
                    tableBody.innerHTML += row;
                });
            } else {
                tableContainer.style.display = "none";
                tableBody.innerHTML = "<tr><td colspan='9'>Nenhum resultado encontrado</td></tr>";
            }
        }
    });
}
</script>

<?php
if (isset($_GET["r"])) {
    $result = $_GET["r"];
    switch ($result) {
        case "atualizado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Atualizado com Sucesso!'
            })</script>";
            break;
        case "erro_att":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'error',
                title: 'Erro ao Atualizar Usuário!'
            })</script>";
            break;
        case "adicionado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Adicionado com Sucesso!'
            })</script>";
            break;
        case "excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Excluído com Sucesso!'
            })</script>";
            break;
        case "all_excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuários Excluídos com Sucesso!'
            })</script>";
            break;
    }
}
?>

<!-- Adicione este código em qualquer lugar dentro do corpo da sua página -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel">ATENÇÃO</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Essa página contém todos os testes gerados através do Teste Automático e ficará Visível a todos os Revendedores...
                <br><br>
                Localize seu Cliente através da Chave do Dispositivo e faça ativação da lista, o cliente passará automaticamente para seu painel.
                <br><br>
                Não faça alterações em outros Clientes!!!
                <br><br>
                Qualquer dúvida, fale com o administrador do Painel.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
    // Função para verificar se o cookie existe
    function checkCookie() {
        var modalShown = getCookie("modalShown");
        if (!modalShown) {
            // Se o cookie não estiver definido, exibe o modal
            $('#myModal').modal('show');
            // Define o cookie para indicar que o modal foi exibido
            setCookie("modalShown", true, 1); // Defina a validade do cookie para 1 dia
        }
    }

    // Função para definir o cookie
    function setCookie(cname, cvalue, exdays) {
        var d = new Date();
        d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
        var expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    // Função para obter o valor do cookie
    function getCookie(cname) {
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }

    // Chame a função para verificar o cookie quando a página é carregada
    $(document).ready(function() {
        checkCookie();
    });
</script>

<?php include './includes/footer.php'; ?>
