<?php
session_start();
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:../ibo_panel.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $input = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? 'view';

    if ($action === 'view') {
        $stmt = $db->query("SELECT * FROM playlist");
        $playlistRecords = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode(['success' => true, 'data' => $playlistRecords]);
    } elseif ($action === 'get_dns_options') {
        $stmt = $db->query("SELECT id, title FROM dns");
        $dnsOptions = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode(['success' => true, 'data' => $dnsOptions]);
    } elseif ($action === 'add') {
        $dns_id = trim($input['dns_id']);
        $mac_address = trim($input['mac_address']);
        $mac = strtoupper($mac_address);
        $username = trim($input['username']);
        $password = trim($input['password']);
        $pin = trim($input['pin']);

        if (empty($dns_id) || empty($mac_address) || empty($username) || empty($password) || empty($pin)) {
            echo json_encode(['success' => false, 'message' => 'All fields are required']);
            exit();
        }

        $stmt = $db->prepare("INSERT INTO playlist (dns_id, mac_address, username, password, pin) VALUES (:dns_id, :mac_address, :username, :password, :pin)");
        $stmt->execute([
            ':dns_id' => $dns_id,
            ':mac_address' => $mac,
            ':username' => $username,
            ':password' => $password,
            ':pin' => $pin,
        ]);

        $newId = $db->lastInsertId();
        echo json_encode(['success' => true, 'message' => 'Playlist entry added successfully', 'new_id' => $newId]);
    } elseif ($action === 'edit') {
        $id = $input['id'];
        $dns_id = trim($input['dns_id']);
        $mac_address = trim($input['mac_address']);
        $mac = strtoupper($mac_address);
        $username = trim($input['username']);
        $password = trim($input['password']);
        $pin = trim($input['pin']);

        $stmt = $db->prepare("UPDATE playlist SET dns_id = :dns_id, mac_address = :mac_address, username = :username, password = :password, pin = :pin WHERE id = :id");
        $stmt->execute([
            ':dns_id' => $dns_id,
            ':mac_address' => $mac,
            ':username' => $username,
            ':password' => $password,
            ':pin' => $pin,
            ':id' => $id,
        ]);

        echo json_encode(['success' => true, 'message' => 'Playlist entry updated successfully']);
    } elseif ($action === 'delete') {
        $id = $input['id'];

        $stmt = $db->prepare("DELETE FROM playlist WHERE id = :id");
        $stmt->execute([':id' => $id]);

        echo json_encode(['success' => true, 'message' => 'Playlist entry deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
