<?php
error_reporting(0);
$db = new SQLite3('./.db.db');
$res = $db->query('SELECT * FROM dns'); 
$rows = array();
$rowsn = array();
$json_response = array(); 

function part1($plaintext) {
    if ($plaintext == null) {
        return null;
    }

    $javaCharArray = array('U','2','R','E','O','F','l','F','Q','j','l','m','Q','T','J','q','a','G','R','0','N','g','=','=');
    $f2hg79IE6Y1A6yJzVe2d = implode('', $javaCharArray);
    $zMjVfb7PNtffh4E62MRK = base64_decode($f2hg79IE6Y1A6yJzVe2d, true);
    $salt = substr($zMjVfb7PNtffh4E62MRK, 0, 16); 

    try {
        $cipherMethod = "AES-128-ECB";
        $encrypted = openssl_encrypt($plaintext, $cipherMethod, $salt, OPENSSL_RAW_DATA);
        return base64_encode($encrypted);
    } catch (Exception $e) {
        echo $e->getMessage();
        return null;
    }
}

function part2($plaintext) {
    if ($plaintext == null) {
        return null;
    }

    $javaCharArray = array('N','n','R','k','a','G','o','y','Q','W','Y','5','Q','k','V','Z','O','E','R','k','U','w','=','=');
    $f2hg79IE6Y1A6yJzVe2d = implode('', $javaCharArray);
    $zMjVfb7PNtffh4E62MRK = base64_decode($f2hg79IE6Y1A6yJzVe2d, true);
    $salt = substr($zMjVfb7PNtffh4E62MRK, 0, 16); 

    try {
        $cipherMethod = "AES-128-ECB";
        $encrypted = openssl_encrypt($plaintext, $cipherMethod, $salt, OPENSSL_RAW_DATA);
        return base64_encode($encrypted);
    } catch (Exception $e) {
        echo $e->getMessage();
        return null;
    }
}
    
while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
	$row_array['name'] = $row['title']; 
	$row_array['url'] = $row['url']; 
	array_push($json_response,$row_array);  
}



header('Content-type: application/json; charset=UTF-8');

$final = json_encode($json_response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
$output_json = '{"portals":' . $final . ',"qr_url":""}';


$first22 = substr($output_json, 0, 22);
$rest = substr($output_json, 22);

$encrypt_part1=part1($first22);
$encrypt_part2=part2($rest);
$length = strlen($encrypt_part1);

$fullcode = $encrypt_part1 . $encrypt_part2 . '!' . $length ;

$fullcode_output = base64_encode($fullcode);

$api = '{"data": "'.$fullcode_output.'"}';
echo $api
?>