<?php
// Conectar ao banco de dados SQLite
$db = new SQLite3('permissoes.db');
$db->busyTimeout(5000); // Aguarda até 5 segundos antes de retornar "database is locked"

// Verificar se a tabela 'mensagens' existe
$tableCheckQuery = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='mensagens'");
$tableExists = $tableCheckQuery->fetchArray();

if ($tableExists) {
    // Consulta para buscar mensagens da tabela mensagens
    $mensagemStmt = $db->prepare("SELECT * FROM mensagens WHERE id = 1");
    $mensagemResult = $mensagemStmt->execute();
    $mensagemRow = $mensagemResult->fetchArray(SQLITE3_ASSOC);

    if ($mensagemRow) {
        // Adicionar as mensagens ao JSON de resposta
        $mensagens = [
            'mensagem_filmes' => $mensagemRow['filmes'] ?? '',
            'mensagem_series' => $mensagemRow['series'] ?? '',
            'mensagem_canais' => $mensagemRow['canais'] ?? ''
        ];

        echo json_encode([
            'status' => 'sucesso',
            'mensagens' => $mensagens
        ], JSON_UNESCAPED_UNICODE);
    } else {
        // Caso não encontre um registro com id = 1
        echo json_encode([
            'status' => 'erro',
            'mensagem' => 'Nenhuma mensagem encontrada para o ID especificado.'
        ], JSON_UNESCAPED_UNICODE);
    }
} else {
    // Caso a tabela não exista
    echo json_encode([
        'status' => 'erro',
        'mensagem' => 'Tabela mensagens não encontrada no banco de dados.'
    ], JSON_UNESCAPED_UNICODE);
}

// Fecha a conexão com o banco
$db->close();
?>
