<?php
// Habilitar la visualización de errores para depuración
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Verificar si la solicitud es POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener el cuerpo de la solicitud
    $inputData = file_get_contents('php://input');

    // Intentar decodificar el JSON
    $data = json_decode($inputData, true);

    // Verificar si la decodificación fue exitosa
    if (json_last_error() === JSON_ERROR_NONE) {
        // Verificar si los parámetros 'mac_address' y 'mac_value' están presentes
        if (isset($data['mac_address']) && isset($data['mac_value'])) {
            $mac_address = strtoupper(trim($data['mac_address'])); // Asegurarse de que el MAC esté en mayúsculas
            $mac_value = $data['mac_value'];

            // Ruta absoluta al archivo JSON
            $jsonFile = __DIR__ . '/api/device_keys.json'; // Usar __DIR__ para obtener la ruta correcta

            // Verificar si el archivo JSON existe
            if (file_exists($jsonFile)) {
                // Cargar el contenido del archivo JSON
                $jsonContent = file_get_contents($jsonFile);
                $jsonData = json_decode($jsonContent, true);

                // Actualizar o agregar el valor del MAC Address
                $jsonData[$mac_address] = $mac_value;

                // Intentar guardar los cambios en el archivo JSON
                if (file_put_contents($jsonFile, json_encode($jsonData, JSON_PRETTY_PRINT))) {
                    echo json_encode(["message" => "Datos guardados con éxito."]);
                } else {
                    echo json_encode(["message" => "Error al guardar los datos."]);
                }
            } else {
                echo json_encode(["message" => "Archivo JSON no encontrado."]);
            }
        } else {
            echo json_encode(["message" => "Parámetros 'mac_address' y 'mac_value' no encontrados."]);
        }
    } else {
        echo json_encode(["message" => "Error al decodificar JSON."]);
    }
} else {
    echo json_encode(["message" => "Método de solicitud inválido."]);
}
?>
