<?php
session_start();

$USERNAME = "admin";
$PASSWORD = "1234"; // Change this!

$config_file = "config.json";
$uploads_dir = "uploads/Images/";
$icon_keys = ["Icon1", "Icon2", "Icon3"];
$server_keys = ["DNS1" => "s1", "DNS2" => "s2", "DNS3" => "s3"];

if (!file_exists($config_file)) {
    die("Missing config.json");
}

$config = json_decode(file_get_contents($config_file), true);

// Login check
if (!isset($_SESSION['logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['username'] === $USERNAME && $_POST['password'] === $PASSWORD) {
        $_SESSION['logged_in'] = true;
        header("Location: admin.php");
        exit();
    }
    echo '<h2>Login</h2><form method="POST">
        Username: <input name="username"><br>
        Password: <input name="password" type="password"><br>
        <button type="submit">Login</button>
    </form>';
    exit();
}

// Logout
if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit();
}

// Handle save
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['save_config'])) {
    foreach ($server_keys as $dns => $folder) {
        foreach (['msg', 'message_on_off', 'message_time', 'slider_time', 'data', 'version', 'appUrl', 'dual_screen', 'tri_screen', 'four_way_screen'] as $field) {
            $config['servers'][$dns][$field] = $_POST[$dns . "_" . $field];
        }

        foreach (['logo', 'mainbg', 'login', 'ad1', 'ad2'] as $img) {
            $input_name = "{$dns}_{$img}";
            if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] === UPLOAD_ERR_OK) {
                $ext = pathinfo($_FILES[$input_name]['name'], PATHINFO_EXTENSION);
                $file_name = "{$img}.{$ext}";
                $target_path = "{$uploads_dir}{$folder}/{$file_name}";
                move_uploaded_file($_FILES[$input_name]['tmp_name'], $target_path);
            }
        }
    }

    // Icon uploads
    foreach ($icon_keys as $icon) {
        if (isset($_FILES[$icon]) && $_FILES[$icon]['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES[$icon]['name'], PATHINFO_EXTENSION);
            $file_name = "{$icon}.{$ext}";
            $path = $uploads_dir . "icons/" . $file_name;
            @mkdir($uploads_dir . "icons", 0777, true);
            move_uploaded_file($_FILES[$icon]['tmp_name'], $path);
            $config['icons'][$icon] = $path;
        }
    }

    file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT));
    header("Location: admin.php?saved=1");
    exit();
}

// Begin HTML
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel</title>
    <style>
        body { font-family: Arial; }
        .tabs { display: flex; gap: 10px; margin-bottom: 20px; }
        .tab { padding: 10px; border: 1px solid #ccc; cursor: pointer; }
        .tab.active { background: #eee; }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        input[type='text'], input[type='url'] { width: 400px; }
    </style>
    <script>
        function showTab(id) {
            document.querySelectorAll(".tab").forEach(t => t.classList.remove("active"));
            document.querySelectorAll(".tab-content").forEach(c => c.classList.remove("active"));
            document.getElementById("tab-" + id).classList.add("active");
            document.getElementById(id).classList.add("active");
        }
    </script>
</head>
<body>
<h2>STB Unified Admin Panel</h2>
<form method="POST"><button name="logout">Logout</button></form>
<form method="POST" enctype="multipart/form-data">
<div class="tabs">
    <?php foreach ($server_keys as $dns => $folder): ?>
        <div class="tab" id="tab-<?= $dns ?>" onclick="showTab('<?= $dns ?>')"><?= $dns ?></div>
    <?php endforeach; ?>
    <div class="tab" id="tab-icons" onclick="showTab('icons')">Icons</div>
</div>

<?php foreach ($server_keys as $dns => $folder): ?>
<div class="tab-content" id="<?= $dns ?>">
    <h3><?= $dns ?> Settings</h3>
    <?php foreach (['msg','message_on_off','message_time','slider_time','data','version','appUrl','dual_screen','tri_screen','four_way_screen'] as $field): ?>
        <?= $field ?>:
        <input name="<?= $dns ?>_<?= $field ?>" value="<?= htmlspecialchars($config['servers'][$dns][$field]) ?>"><br>
    <?php endforeach; ?>
    <br>
    <?php foreach (['logo','mainbg','login','ad1','ad2'] as $img): ?>
        <?= $img ?> image: <input type="file" name="<?= $dns ?>_<?= $img ?>"><br>
    <?php endforeach; ?>
</div>
<?php endforeach; ?>

<div class="tab-content" id="icons">
    <h3>Icon Image Uploads</h3>
    <?php foreach ($icon_keys as $icon): ?>
        <?= $icon ?>: <input type="file" name="<?= $icon ?>"><br>
    <?php endforeach; ?>
</div>

<br><br>
<button name="save_config" type="submit">Save Configuration</button>
</form>

<script>showTab('DNS1');</script>
</body>
</html>
