<?php
require_once __DIR__ . '/includes/auth.php';
require_login();

require_once __DIR__ . '/includes/functions.php';

$title  = 'Dashboard';
$active = 'dashboard';

/* -----------------------
   DATA (FIXED)
------------------------ */

// RAW portals (admin view – includes disabled / empty)
$rawData   = read_portals();
$allPortals = $rawData['portals'] ?? [];

// ENABLED + NON-EMPTY ONLY (real state)
$enabledPortals = get_enabled_portals();

include __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">

  <!-- ===== STATS ===== -->
  <div class="row mb-4">

    <div class="col-md-4">
      <div class="card bg-dark border-secondary">
        <div class="card-body">
          <div class="text-muted small">Total DNS Rows</div>
          <div class="h3"><?= count($allPortals); ?></div>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card bg-dark border-success">
        <div class="card-body">
          <div class="text-muted small">Enabled DNS</div>
          <div class="h3 text-success"><?= count($enabledPortals); ?></div>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card bg-dark border-danger">
        <div class="card-body">
          <div class="text-muted small">Disabled / Empty</div>
          <div class="h3 text-danger">
            <?= count($allPortals) - count($enabledPortals); ?>
          </div>
        </div>
      </div>
    </div>

  </div>

  <!-- ===== DNS TABLE ===== -->
  <div class="card bg-dark border-secondary">
    <div class="card-header">
      <strong>DNS Portals Status</strong>
    </div>

    <div class="card-body p-0">
      <table class="table table-dark table-striped mb-0">
        <thead>
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>DNS URL</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>

        <?php if (empty($allPortals)): ?>
          <tr>
            <td colspan="4" class="text-center text-muted p-4">
              No DNS entries found
            </td>
          </tr>
        <?php endif; ?>

        <?php foreach ($allPortals as $i => $portal): 

          $name = trim($portal['name'] ?? '');
          $url  = trim($portal['url'] ?? '');
          $enabled = $portal['enabled'] ?? false;

          if ($enabled && $name !== '' && $url !== '') {
              $status = '<span class="badge bg-success">ENABLED</span>';
          } elseif ($name === '' || $url === '') {
              $status = '<span class="badge bg-secondary">EMPTY</span>';
          } else {
              $status = '<span class="badge bg-danger">DISABLED</span>';
          }
        ?>

          <tr>
            <td><?= $i + 1; ?></td>
            <td><?= htmlspecialchars($name ?: '—'); ?></td>
            <td class="text-muted small">
              <?= htmlspecialchars($url ?: '—'); ?>
            </td>
            <td><?= $status; ?></td>
          </tr>

        <?php endforeach; ?>

        </tbody>
      </table>
    </div>
  </div>

</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
